//
//  MCReportTextArea.h
//  Composer
//
//  Created by Alykhan Jetha on 26/07/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import "MCReportElement.h"

@class MCReportTextView;

@interface MCReportTextArea : MCReportElement <NSTextViewDelegate> {
	NSTextStorage *textStorage;
	
	int typeCode;  // dynamic or static
	
	NSString *formatterClassName;
	NSString *formatterFormat;
	int formatterCode;
	
	BOOL evaluateAsScript;
	
	NSDictionary *typingAttributes;
	
	MCReportTextView *textEditor;
	
	int textAlignment;
	
	float rotationAngle;
	
}


- (void)addTokensThatContainKeyPath:(NSString *)aKeyPath toArray:(NSMutableArray *)anArray;
- (void)addElementsWithFormatterCode:(int)aFormatterCode toArray:(NSMutableArray *)anArray;


// for subclassers for special cases - defaults is NSTextStorage
- (void)allocateTextStorage;

- (NSTextStorage *)textStorage;
- (void)setTextStorage:(NSTextStorage *)aTextStorage;

- (NSTextView *)drawingTextView;

- (MCReportTextView *)textEditor;
- (void)setTextEditor:(MCReportTextView *)aTextEditor;
- (MCReportTextView *)resolvedTextEditor;

- (void)layoutDidReceiveDoubleClick:(NSEvent *)theEvent;

- (int)typeCode;
- (void)setTypeCode:(int)aTypeCode;
- (BOOL)isDynamic;
- (void)setIsDynamic:(BOOL)flag;
- (BOOL)canBecomeDynamic;
- (void)ensureTextStorageIsDynamic;

// support for page number element - a subclass
- (BOOL)canHideIfOnlyOnePage;
- (void)setHiddenIfOnlyOnePage:(BOOL)flag;
- (BOOL)hiddenIfOnlyOnePage;

- (NSString *)formatterClassName;
- (void)setFormatterClassName:(NSString *)aFormatterClassName;

- (NSString *)formatterFormat;
- (void)setFormatterFormat:(NSString *)aFormatterFormat;

- (int)formatterCode;
- (void)setFormatterCode:(int)aFormatterCode;

- (BOOL)evaluateAsScript;
- (void)setEvaluateAsScript:(BOOL)flag;

- (NSDictionary *)typingAttributes;
- (void)setTypingAttributes:(NSDictionary *)aTypingAttributes;

// attempts to get the attributes of the first character
- (NSDictionary *)firstCharacterAttributesWithoutToken;

- (NSFont *)firstCharacterFont;
- (void)setFont:(NSFont *)aFont;
- (void)changeToFontWithNameMaintainPointSize:(NSString *)aFontName;

- (void)setForegroundColor:(NSColor *)aColor;

- (int)formatterTypeCode;
- (void)setFormatterTypeCode:(int)aCode;

// sets the alignment of the whole thing
- (void)setTextAlignment:(NSTextAlignment)align;
- (void)setVerticalTextAlignment:(int)aCode;

// replace the whole string while trying to maintain attributes
- (void)setTextString:(NSString *)aString;
- (void)clearContent;

// adds aString to the text storage with the current typing attributes
- (void)appendTextString:(NSString *)aString;

- (void)appendLabel:(NSString *)aLabel 
			keypath:(NSString *)aKeypath 
		  formatter:(NSFormatter *)aFormatter 
		  alignment:(NSTextAlignment)alignment;

- (void)appendLabel:(NSString *)aLabel 
			keypath:(NSString *)aKeypath 
		  formatter:(NSFormatter *)aFormatter
	  formatterCode:(int)aFormatterCode
		  alignment:(NSTextAlignment)alignment;

- (void)appendCurrentDateTokenWithLabel:(NSString *)aLabel formatterCode:(int)aCode;

// aString and aNewString must be valid (empty is ok). Looks for the range and tries to put in the new word using the same attributes. Finds the first string only
- (void)replaceString:(NSString *)aString withString:(NSString *)aNewString;

- (void)removeElementsWithKeyPathContaining:(NSString *)aKp;

- (NSArray *)tokens;
- (NSArray *)tokensWithScript; 
- (BOOL)hasScriptInTokens;

- (NSArray *)validFormatOptions;

- (void)sizeToFit;

- (IBAction)writeTypingAttributesToDefaults:(id)sender;
- (void)readTypingAttributesFromDefaults;

- (int)verticalTextAlignment;
- (void)setVerticalTextAlignment:(int)aCode;
@end

@interface MCReportElement (MCReportFontAddition)

- (void)propagateChangeToFontWithNameAndMaintainPointSize:(NSString *)aFontName;
- (void)propagateFont:(NSFont *)aFont;
- (void)propagateForegroundColor:(NSColor *)aColor;
- (void)propagateSizeToFit;

@end

